use image::{self,Rgba};
use rand;
//➀クレートの読み込み
use imageproc::drawing::draw_text_mut;
//➁クレートの読み込み
use rusttype::{Font, Scale};

fn main() {
    let draw = |_x, _y| {
        let r = rand::random::<u8>();
        let g = rand::random::<u8>();
        let b = rand::random::<u8>();
        Rgba::<u8>([r,g,b,255])
    };
    //➂書き換え可能に
    let mut img = image::ImageBuffer::from_fn(512, 512, draw);
    //⓸フォントファイル名を設定
    let font = Vec::from(include_bytes!("../YuGothB.ttc") as &[u8]);
    //➄フォントの読み込み
    let font = Font::try_from_vec(font).unwrap();
    //➅文字の大きさ
    let scale = Scale {
        //➆文字の幅
        x: 100_f32,
        //➇文字の高さ
        y: 100_f32,
    };
    //➈描画する文字列
    let text = "Sample";
    //➉フォントの色
    let color = Rgba([255u8,255u8,255u8,255u8]);
    //⑪文字列を描画
    draw_text_mut(&mut img,color,50,40,scale,&font,text);
    //⑫文字列を描画
    draw_text_mut(&mut img,color,150,150,scale,&font,text);
    //⑬文字列を描画
    draw_text_mut(&mut img,color,50,260,scale,&font,text);
    //⑭文字列を描画
    draw_text_mut(&mut img,color,150,370,scale,&font,text);
    img.save("draw_font.png").unwrap();
}
