//➀画像を扱うクレート
use image::{self,Rgba};
//➁乱数を扱うクレート
use rand;
//➂最初に呼ばれるメイン関数
fn main() {
    //⓸ランダムな色を返すクロージャ
    let draw = |_x, _y| {
        //➄0～255の乱数を赤色に
        let r = rand::random::<u8>();
        //➅0～255の乱数を緑色に
        let g = rand::random::<u8>();
        //➆0～255の乱数を青色に
        let b = rand::random::<u8>();
        //➇ランダムな赤緑青からなる色
        Rgba::<u8>([r,g,b,255])
    };
    //➈512x512の画像を生成
    let img = image::ImageBuffer::from_fn(512, 512, draw);
    //➉画像を「image_rand.png」ファイルに保存
    img.save("image_rand.png").unwrap();
}
