use image::{self,Rgba};
use imageproc::drawing::draw_text_mut;
use rusttype::{Font, Scale};

fn main() {
    //➀画像の読み込み
    let mut img = image::open("sample.png").unwrap();
    let font = Vec::from(include_bytes!("../YuGothB.ttc") as &[u8]);
    let font = Font::try_from_vec(font).unwrap();
    let scale = Scale {
        x: 100_f32,
        y: 100_f32,
    };
    let text = "Sample";
    let color = Rgba([255u8,255u8,255u8,255u8]);
    //➁文字列を描画
    draw_text_mut(&mut img,color,50,200,scale,&font,text);
    //➂文字列を描画
    draw_text_mut(&mut img,color,400,400,scale,&font,text);
    //⓸文字列を描画
    draw_text_mut(&mut img,color,50,600,scale,&font,text);
    //➄文字列を描画
    draw_text_mut(&mut img,color,400,800,scale,&font,text);
    img.save("load_image.png").unwrap();
}
